<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @license       https://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace DebugKit\Panel;

use Cake\Core\Configure;
use Cake\Error\Debugger;
use Cake\Event\EventInterface;
use DebugKit\DebugPanel;
use function Cake\Core\deprecationWarning;

/**
 * Provides debug information on the Session contents.
 */
class SessionPanel extends DebugPanel
{
    /**
     * shutdown callback
     *
     * @param \Cake\Event\EventInterface $event The event
     * @return void
     */
    public function shutdown(EventInterface $event): void
    {
        deprecationWarning(
            '5.1.0',
            'SessionPanel is deprecated. Remove it from your panel list, and use Request panel instead.'
        );
        /** @var \Cake\Controller\Controller $controller */
        $controller = $event->getSubject();
        $request = $controller->getRequest();

        $maxDepth = Configure::read('DebugKit.maxDepth', 5);
        $content = Debugger::exportVarAsNodes($request->getSession()->read(), $maxDepth);
        $this->_data = compact('content');
    }
}
