<style>
  .breadcrumb-slider-container {
    width: 100%;
    height: 40vh;
    position: relative;
    overflow: hidden;
  }

  swiper-container.breadcrumb-swiper {
    width: 100%;
    height: 100%;
  }

  swiper-slide.breadcrumb-slide {
    background-position: center;
    background-size: cover;
    position: relative;
  }

  swiper-slide.breadcrumb-slide img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: middle;
  }

  swiper-slide.breadcrumb-slide::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    /* background: rgba(0, 0, 0, 0.5); */
    /* Dark overlay */
    z-index: 1;
  }

  .breadcrumb-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: flex-end;
    z-index: 2;
    padding-bottom: 2rem;
  }

  .breadcrumb {
    display: flex;
    flex-wrap: wrap;
    padding: 0.75rem 2rem;
    margin: 0 auto;
    list-style: none;
    font-size: 0.9rem;
    background-color: rgba(255, 255, 255, 0.8);
    border-radius: 4px;
    max-width: 80%;
  }

  .breadcrumb-item {
    display: flex;
    align-items: center;
    color: #333;
  }

  .breadcrumb-item+.breadcrumb-item::before {
    content: "/";
    display: inline-block;
    padding: 0 0.5rem;
    color: #666;
  }

  .breadcrumb-item a {
    color: #007bff;
    text-decoration: none;
    transition: color 0.15s ease-in-out;
  }

  .breadcrumb-item a:hover {
    color: #0056b3;
    text-decoration: underline;
  }

  .breadcrumb-item.active {
    color: #333;
    font-weight: 500;
  }

  /* Media query for mobile devices */
  @media (max-width: 480px) {
    .breadcrumb-slider-container {
      height: 25vh;
    }

    .breadcrumb {
      padding: 0.5rem 1rem;
      font-size: 0.8rem;
      max-width: 90%;
    }

    .breadcrumb-item+.breadcrumb-item::before {
      padding: 0 0.3rem;
    }

    .breadcrumb-overlay {
      padding-bottom: 1rem;
    }
  }
</style>

<section>
  <div class="breadcrumb-slider-container">
    <swiper-container class="breadcrumb-swiper" pagination="true" pagination-clickable="true" autoplay-delay="3000"
      autoplay-disable-on-interaction="false" loop="true">
      <?php foreach ($banners as $banner): ?>
        <swiper-slide class="breadcrumb-slide">
          <img src="<?= $this->Url->image($banner->image_path) ?>" alt="<?= h($banner->title) ?>" />
        </swiper-slide>
      <?php endforeach; ?>
    </swiper-container>
  </div>
</section>

<section>
  <!-- <//?= $this->element('snippets/simple/page_heading') ?> -->
</section>