<style>
  .wel_img_divs {
    overflow: hidden;
    border-radius: 0.75rem;
  }

  .wel_img_divs img {
    transition: transform 0.4s ease;
  }

  .wel_img_divs:hover img {
    /* transform: scale(1.05); */
  }

  .card.bg-primary {
    background-color: #e9f3ff !important;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
  }

  .card.bg-primary:hover {
    transform: translateY(-5px);
    box-shadow: 0 0.75rem 1.5rem rgba(0, 0, 0, 0.1);
  }

  .text-darkred {
    color: #035096 !important;
  }

  .btn-primary {
    background-color: #035096;
    border: none;
    transition: background-color 0.3s ease, transform 0.2s ease;
  }

  .btn-primary:hover {
    background-color: #023e78;
    transform: translateY(-2px);
  }

  h2 {
    font-weight: 700;
    font-size: 1.75rem;
    color: #1f1f1f;
  }

  p {
    color: #555;
    line-height: 1.7;
  }

  h6 {
    font-size: 1rem;
  }

  .shadow-sm {
    border-radius: 1rem;
  }

  .section-title-icon {
    font-size: 1.25rem;
    color: #035096;
  }

  .bullet_back{
  background-color:#e3effb;
}

.c_bullet ul {
  list-style: none;
  margin-left:0px;
  margin-right:20px;
  line-height:30px;
}
.c_bullet ul li::before {
  content: "\21D2";
  position:absolute;
  line-height:30px;
  color: #398075;
  font-weight: bolder;
  font-size:15px;
  display: inline-block;
  width: 15px;
  margin-left:-30px;
  display:block;
}

</style>

<section class="py-1 bg-light">
  <div class="container ">

    <div class="row">
      <?= $this->element('snippets/simple/element_section_heading', ['menuDetails' => $menuDetails]); ?>
    </div>

    <div class="row">
      <?php foreach ($viewContent as $index => $content): ?>

        <?php $link = $this->Url->build([
          'controller' => $this->request->getParam('subsection') ?: ($this->request->getParam('section') ?: $this->request->getParam('controller')),
          'action' => 'details',
          $content->id
        ]) ?>

        <div class="col-12 mb-4">
          <div class="row p-3 gx-5 mb-3"> <!-- Apply shadow and padding to inner row -->
            <?php if ($index % 2 === 0): ?>
              <!-- image section -->
              <div class="col-12 col-lg-6 mb-3 mb-lg-0">
                <div class="shadow">
                  <img
                    src="<?= $this->Url->image(sizeof($content->content_images) > 0 ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                    class="img-fluid h-100 object-fit-cover" alt="<?= h($viewContent[0]->name) ?>" />
                </div>
              </div>

              <!-- text section -->
              <div class="col-12 col-lg-6">
                <!-- <h2 class="text-darkred"><//?= $content->name ?></h2> -->
                <div class="c_bullet">
              
                  <?= $content->content ?>
                  <!-- <//?= $this->Text->truncate(strip_tags($content->content), 200, ['ellipsis' => '...', 'exact' => false]) ?> -->
               
            </div>

              </div>
            </div>

          <?php else: ?>
            <!-- text section -->
            <div class="col-12 col-lg-6">
              <h2 class="text-darkred"><?= $content->name ?></h2>

              <p><?= $this->Text->truncate(strip_tags($content->content), 200, ['ellipsis' => '...', 'exact' => false]) ?>
              </p>

              <h4 class="mb-3"><i class="bi bi-shield me-2 text-darkred"></i>Quick Terms </h4>

              <div class="row mb-3 g-lg-3">
                <div class="col-md-6 mb-3 mb-lg-0">
                  <div class="card border-0 border-3 shadow-sm rounded-3 h-100 bg-primary">
                    <div class="card-body d-flex flex-column justify-content-center">
                      <div class="d-flex align-items-center mb-2">
                        <i class="bi bi-currency-dollar text-darkred me-2 fs-5"></i>

                        <h6 class="mb-0 fw-medium text-darkred">Loan Amount</h6>
                      </div>
                      <p class="mb-0 text-dark fw-bold"><?= $content->fa_icon ?></p>
                    </div>
                  </div>
                </div>

                <div class="col-md-6 mb-lg-3 mb-lg-0">
                  <div class="card border-0 border-3 shadow-sm rounded-3 h-100 bg-primary">
                    <div class="card-body d-flex flex-column justify-content-center">
                      <div class="d-flex align-items-center mb-2">
                        <i class="bi bi-percent text-darkred me-2 fs-5"></i>
                        <h6 class="mb-0 fw-medium text-darkred">Interest Rate</h6>
                      </div>
                      <p class="mb-0 text-dark fw-bold"><?= $content->file_path ?></p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row mb-3 g-lg-3">
                <div class="col-md-6 mb-3 mb-lg-0">
                  <div class="card border-0 border-3 shadow-sm rounded-3 h-100 bg-primary">
                    <div class="card-body d-flex flex-column justify-content-center">
                      <div class="d-flex align-items-center mb-2">
                        <i class="bi bi-calendar text-darkred me-2 fs-5"></i>
                        <h6 class="mb-0 fw-medium text-darkred">Repayment</h6>
                      </div>
                      <p class="mb-0 text-dark fw-bold"><?= $content->map_address ?></p>
                    </div>
                  </div>
                </div>

                <div class="col-md-6 mb-3 mb-lg-0">
                  <div class="card border-0 border-3 shadow-sm rounded-3 h-100 bg-primary">
                    <div class="card-body d-flex flex-column justify-content-center">
                      <div class="d-flex align-items-center mb-2">
                        <i class="bi bi-people text-darkred me-2 fs-5"></i>
                        <h6 class="mb-0 fw-medium text-darkred">Eligibility</h6>
                      </div>
                      <p class="mb-0 text-dark fw-bold"><?= $content->caption ?></p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row mt-lg-4">
                <div class="col-md-6 mb-3 mb-lg-0">
                  <a href="" class="btn btn-primary btn-lg px-lg-5">Apply Now <i class="bi bi-arrow-right-short"></i></a>
                </div>
                <div class="col-md-6 mb-3 mb-lg-0">
                  <a href="<?= $link ?>" class="btn btn-outline-primary btn-lg px-lg-5">Learn More</i></a>
                </div>
              </div>

            </div>

            <!-- image section -->
            <div class="col-12 col-lg-6 mb-3 mb-lg-0">
              <div class="wel_img_divs h-100">
                <img
                  src="<?= $this->Url->image(sizeof($content->content_imagess) > 0 ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                  class="img-fluid h-100 object-fit-cover" alt="<?= h($viewContent[0]->name) ?>" />
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
  </div>
</section>