<section class="py-3 py-md-5 bg-light">
  <div class="container">
    <div class="row justify-content-center">
      <?php foreach ($viewContent as $content): ?>

        <?php $link = $this->Url->build(['controller' => $slug, 'action' => 'details', $content->id])?>

        <div class="col-12 col-md-10 col-lg-8 mb-3">

          <!-- Main heading -->
          <a href="<?= $link ?>" class="text-decoration-none text-dark text-md-center d-block mb-3">
            <h1 class="display-6 fw-medium"><?= h($content->name) ?></h1>
          </a>

          <!-- Content section -->
          <div class="fs-6 text-muted mb-4 text-md-center px-2 px-md-4">
            <?= $this->Text->truncate(strip_tags($content->content), 300, ['ellipsis' => '...', 'exact' => false]) ?>
          </div>

          <!-- Call-to-action button -->
          <div class="text-md-center">
            <a href="<?= $link ?>" class="btn btn-secondary btn-lg px-4 fw-bold shadow-sm">
              Read More
            </a>
          </div>

        </div>
      <?php endforeach ?>
    </div>
  </div>
</section>
