<!-- Link Swiper's CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

<!-- Styles -->
<style>
  .swiper.bannerSwiper {
    height: 500px;
    width: 100%;
  }

  .banner-swiper-slide::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.2);
  }

  .swiper-slide img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: top;
  }

  .text-container {
    position: absolute;
    top: 50%;
    left: 20%;
    z-index: 2;
    color: white;
    transform: translateY(-50%);
  }

  .swiper-button-next,
  .swiper-button-prev {
    color: white;
    z-index: 10;
  }

  .swiper-pagination-bullet {
    background: white;
    z-index: 10;
  }

  /* Responsive styles */
  @media (max-width: 768px) {
    .swiper.bannerSwiper {
      height: 200px;
    }

    .swiper-button-next,
    .swiper-button-prev {
      display: none !important;
    }

    .text-container {
      left: 10%;
      font-size: 14px;
    }
  }
</style>

<!-- Swiper -->
<div class="swiper bannerSwiper">
  <div class="swiper-wrapper">
    <?php foreach ($banners as $banner): ?>
      <div class="swiper-slide banner-swiper-slide">
        <img src="<?= $this->Url->image($banner->image_path) ?>" alt="<?= h($banner->title) ?>" />
      </div>
    <?php endforeach; ?>
  </div>

  <!-- Navigation and Pagination (must be inside the swiper container) -->
  <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div>
  <div class="swiper-pagination"></div>
</div>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<!-- Initialize Swiper -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var swiper = new Swiper(".bannerSwiper", {
      spaceBetween: 30,
      centeredSlides: true,
      autoplay: {
        delay: 2500,
        disableOnInteraction: false,
      },
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
    });
  });
</script>