<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     3.0.0
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\View;

use Cake\View\View;

/**
 * Application View
 *
 * Your application's default view class
 *
 * @link https://book.cakephp.org/5/en/views.html#the-app-view
 */
class AppView extends View
{
    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like adding helpers.
     *
     * e.g. `$this->addHelper('Html');`
     *
     * @return void
     */
    public function initialize(): void
    {
        $this->Html->css('bootstrap.min', ['block' => true]);
        $this->Html->css('normalize.min', ['block' => true]);
        $this->Html->css('aos.css', ['block' => true]);
        $this->Html->css('menu', ['block' => true]);
        $this->Html->css('icomoon', ['block' => true]);
        $this->Html->css('global', ['block' => true]);
        $this->Html->css('odometer', ['block' => true]);


        $this->Html->script('bootstrap.bundle.min', ['block' => true]);
        $this->Html->script('aos.js', ['block' => true]);
        $this->Html->script('odometer', ['block' => true]);
        $this->Html->script('gsap.min', ['block' => true]);
        $this->Html->script('custom_animation.js', ['block' => true]);



        //Loading cdn links
        $this->Html->css('https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css', ['block' => true]);
        $this->Html->css('https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css', ['block' => true]);
        $this->Html->script('https://cdn.jsdelivr.net/npm/swiper@11/swiper-element-bundle.min.js', ['block' => 'swiperBottom']);
        $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', ['block' => true]);

    }
}
