<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SectionBannerAssoc Model
 *
 * @property \App\Model\Table\BannersTable&\Cake\ORM\Association\BelongsTo $Banners
 *
 * @method \App\Model\Entity\SectionBannerAssoc newEmptyEntity()
 * @method \App\Model\Entity\SectionBannerAssoc newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\SectionBannerAssoc> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\SectionBannerAssoc get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\SectionBannerAssoc findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\SectionBannerAssoc patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\SectionBannerAssoc> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\SectionBannerAssoc|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\SectionBannerAssoc saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\SectionBannerAssoc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\SectionBannerAssoc>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\SectionBannerAssoc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\SectionBannerAssoc> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\SectionBannerAssoc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\SectionBannerAssoc>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\SectionBannerAssoc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\SectionBannerAssoc> deleteManyOrFail(iterable $entities, array $options = [])
 */
class SectionBannerAssocTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('section_banner_assoc');
        $this->setDisplayField(['section_id', 'banner_id']);
        $this->setPrimaryKey(['section_id', 'banner_id']);

        $this->belongsTo('Banners', [
            'foreignKey' => 'banner_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['banner_id'], 'Banners'), ['errorField' => 'banner_id']);

        return $rules;
    }
}
