<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Banners Model
 *
 * @property \App\Model\Table\SectionBannerAssocTable&\Cake\ORM\Association\HasMany $SectionBannerAssoc
 *
 * @method \App\Model\Entity\Banner newEmptyEntity()
 * @method \App\Model\Entity\Banner newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Banner> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Banner get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Banner findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Banner patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Banner> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Banner|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Banner saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Banner>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Banner>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Banner>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Banner> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Banner>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Banner>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Banner>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Banner> deleteManyOrFail(iterable $entities, array $options = [])
 */
class BannersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('banners');
        $this->setDisplayField('title');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('SectionBannerAssoc', [
            'foreignKey' => 'banner_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('title')
            ->maxLength('title', 255)
            ->requirePresence('title', 'create')
            ->notEmptyString('title');

        $validator
            ->scalar('description')
            ->maxLength('description', 255)
            ->requirePresence('description', 'create')
            ->notEmptyString('description');

        $validator
            ->scalar('image_path')
            ->maxLength('image_path', 255)
            ->requirePresence('image_path', 'create')
            ->notEmptyString('image_path');

        $validator
            ->integer('status')
            ->notEmptyString('status');

        $validator
            ->scalar('url_link')
            ->maxLength('url_link', 500)
            ->allowEmptyString('url_link');

        return $validator;
    }
}
