<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * News Entity
 *
 * @property int $id
 * @property string $title
 * @property string $description
 * @property string $author
 * @property \Cake\I18n\DateTime $date_created
 * @property int $status
 * @property string $image_path
 * @property string $content
 * @property int $views
 * @property string $image_caption
 * @property string $source
 * @property int $featured
 */
class News extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'title' => true,
        'description' => true,
        'author' => true,
        'date_created' => true,
        'status' => true,
        'image_path' => true,
        'content' => true,
        'views' => true,
        'image_caption' => true,
        'source' => true,
        'featured' => true,
    ];
}
