<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Event Entity
 *
 * @property int $id
 * @property string $title
 * @property string $description
 * @property \Cake\I18n\Date $event_start_date
 * @property string $price
 * @property \Cake\I18n\DateTime $date_created
 * @property int $status
 * @property string $author
 * @property string $location
 * @property \Cake\I18n\Date $event_end_date
 * @property string $organizer
 * @property string $image_path
 * @property \Cake\I18n\Time $start_time
 * @property \Cake\I18n\Time $end_time
 * @property string $category
 * @property string $theme
 * @property int $featured
 */
class Event extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'title' => true,
        'description' => true,
        'event_start_date' => true,
        'price' => true,
        'date_created' => true,
        'status' => true,
        'author' => true,
        'location' => true,
        'event_end_date' => true,
        'organizer' => true,
        'image_path' => true,
        'start_time' => true,
        'end_time' => true,
        'category' => true,
        'theme' => true,
        'featured' => true,
    ];
}
