<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Http\Exception\NotFoundException;

/**
 * Static content controller
 *
 * This controller will render views from Template/Gallery/
 *
 */
class GalleryController extends AppController
{
	/**
	 * Initialization hook method.
	 *
	 * Use this method to add common initialization code like loading components.
	 *
	 * e.g. `$this->loadComponent('Security');`
	 *
	 * @return void
	 */
	public function initialize(): void
	{
		parent::initialize();

		$this->PageContents = $this->fetchTable('PageContents');
		$this->Galleries = $this->fetchTable('Galleries');
		$this->Banners = $this->fetchTable('Banners');

	}

	public function index()
	{
		/** 
		 * Default home for basic section features
		 *
		 * The selected menu is in the section param of the request
		 * Lets retreive the data and load the content for that section
		 * 
		 */

		// Retrieve the menu using the section (Should be the gallery slug)
		$menuDetails = $this->PageContents->Menus->find('all', [
			'conditions' => [
				'slug' => 'gallery'
			]
		])->first();

		/**
		 * Only load the content if the menu is active, else log the issue and throw a not found exception
		 * And ofcourse, if no menu is found with the section slug, then there is no need to continue as well
		 */
		if ($menuDetails == null) {
			$this->log('No menu found with the selected slug: ' . $this->request->getParam('section'), 'debug');
			throw new NotFoundException();
		} else if ($menuDetails->status != 1) {
			$this->log('Menu found with slug: ' . $this->request->getParam('section') . ' but not active', 'debug');
			throw new NotFoundException();
		}

		// Initialize the content array and populate the contents of each section
		$viewContent = $this->Galleries->Albums->find('all', [
			'contain' => [
				'Galleries'
			],
			'conditions' => [
				'Albums.status' => 1
			]
		]);

		// Load the gallery records
		// Lets get all the pictures
		$galleryDetails = $this->Galleries->find('all', [
			'conditions' => [
				'status' => 1
			]
		]);

		/**
		 * Perform additional task here before sending the values
		 * to be rendered on the view
		 */
		$banners = $this->Banners->find('all', [
			'conditions' => [
				'status' => 5
			]
		])
			->order(['rand()'])
			->limit(1)
			->toArray();
		/**
		 * Perform additional task here before sending the values
		 * to be rendered on the view
		 */

		$this->set(compact('viewContent', 'menuDetails', 'banners','galleryDetails'));
	}

	public function details($album_id = null)
	{
		/** 
		 * Details for processing the galleries in a transaction
		 * 
		 */

		// Without any album id, throw a not found exception
		if ($album_id == null) {
			$this->log('Album has a null value, throwing not found exception', 'debug');
			throw new NotFoundException();
		}

		// Retrieve the menu using the section (Should be the gallery slug)
		$menuDetails = $this->PageContents->Menus->find('all', [
			'conditions' => [
				'slug' => 'gallery'
			]
		])->first();

		/**
		 * Only load the content if the menu is active, else log the issue and throw a not found exception
		 * And ofcourse, if no menu is found with the section slug, then there is no need to continue as well
		 */
		if ($menuDetails == null) {
			$this->log('No menu found with the selected slug: ' . $this->request->getParam('section'), 'debug');
			throw new NotFoundException();
		} else if ($menuDetails->status != 1) {
			$this->log('Menu found with slug: ' . $this->request->getParam('section') . ' but not active', 'debug');
			throw new NotFoundException();
		}

		// Initialize the content array and populate the contents of each section
		$viewContent = $this->Galleries->Albums->find('all', [
			'conditions' => [
				'Albums.status' => 1,
				'Albums.id' => $album_id
			]
		])->first();

		$sectionTitle = ($viewContent != null) ? $viewContent->name : null;

		// Load the gallery records
		// Lets get all the pictures
		$galleryDetails = $this->Galleries->find('all', [
			'conditions' => [
				'status' => 1,
				'album_id' => $album_id
			]
		]);

		/**
		 * Perform additional task here before sending the values
		 * to be rendered on the view
		 */
		$banners = $this->Banners->find('all', [
			'conditions' => [
				'status' => 5
			]
		])
			->order(['rand()'])
			->limit(1)
			->toArray();
		/**
		 * Perform additional task here before sending the values
		 * to be rendered on the view
		 */

		$this->set(compact('viewContent', 'menuDetails', 'galleryDetails', 'sectionTitle', 'banners'));
	}
}
